<?php
/*
 * Plugin Name: html newsletter
 * Description: A plugin to create and send HTML newsletters.
 * Version: 1.0
 */

// It's best practice to have separate functions for activation and deactivation.
register_activation_hook(
	__FILE__,
	'hns_on_activate'
);

register_deactivation_hook(
	__FILE__,
	'hns_on_deactivate'
);

/**
 * This function runs when the plugin is activated.
 */
function hns_on_activate() {
	// Activation code goes here.
	// For example, creating a database table or setting default options.
}

/**
 * This function runs when the plugin is deactivated.
 */
function hns_on_deactivate() {
	// Deactivation code goes here.
	// For example, cleaning up options.
}

/**
 * Adds the plugin menu page to the Tools menu.
 */
function hns_add_tools_menu_page() {
	add_submenu_page(
		'tools.php',                 // Parent slug
		'HTML Newsletter',           // Page title (in browser tab)
		'HTML Newsletter',           // Menu title (in the menu)
		'manage_options',            // Capability required to see this item
		'html-newsletter-admin',     // Menu slug (unique identifier)
		'hns_render_admin_page'      // Function that renders the page content
	);
}
add_action( 'admin_menu', 'hns_add_tools_menu_page' );
/**
 * Renders the content for the admin page.
 */
function hns_render_admin_page() {
	// Get the previously submitted tag name to make the input field "sticky".
	$submitted_tag = '';
	if ( isset( $_POST['tag_name'] ) ) {
		$submitted_tag = esc_attr( $_POST['tag_name'] );
	}
	?>
	<div class="wrap">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		<p>Enter a tag to generate the HTML for all associated posts.</p>

		<form method="post" action="">
			<?php wp_nonce_field( 'hns_get_articles_action', 'hns_nonce' ); ?>
			<table class="form-table" role="presentation">
				<tbody>
					<tr>
						<th scope="row"><label for="tag_name">Enter Tag Name:</label></th>
						<td><input type="text" name="tag_name" id="tag_name" value="<?php echo $submitted_tag; ?>" class="regular-text"></td>
					</tr>
				</tbody>
			</table>
			<?php submit_button( 'Generate HTML' ); ?>
		</form>

		<hr/>

		<?php
		// Check if the form was submitted and the nonce is valid.
		if ( isset( $_POST['submit'] ) && isset( $_POST['hns_nonce'] ) && wp_verify_nonce( sanitize_key( $_POST['hns_nonce'] ), 'hns_get_articles_action' ) ) {

			if ( ! empty( $_POST['tag_name'] ) ) {
				$tag_name = sanitize_text_field( $_POST['tag_name'] );
				$articles = get_posts(
					array(
						'tag'            => $tag_name,
						'posts_per_page' => -1,
					)
				);

				if ( $articles ) {
					// Start output buffering.
					ob_start();

					global $post;
					foreach ( $articles as $post ) {
						setup_postdata( $post );
						?>
						<div class="hns-article" style="margin-bottom: 2.5em; padding-bottom: 1.5em; border-bottom: 1px solid #ddd;">
							<h3><a href="<?php the_permalink(); ?>" target="_blank"><?php the_title(); ?></a></h3>

							<?php if ( has_post_thumbnail() ) : ?>
								<div class="hns-featured-image" style="float: left; margin: 0 15px 10px 0;">
									<a href="<?php the_permalink(); ?>" target="_blank">
										<?php the_post_thumbnail( 'thumbnail' ); ?>
									</a>
								</div>
							<?php endif; ?>

							<div class="hns-article-content">
								<?php the_content( 'Continue reading &rarr;' ); ?>
							</div>
							<div style="clear: both;"></div>
						</div>
						<?php
					}
					wp_reset_postdata();

					// Get the contents of the buffer and store it in a variable.
					$html_for_export = ob_get_clean();

					// --- 1. Display the rendered preview ---
					echo '<h2>Preview of Articles</h2>';
					echo $html_for_export;

					// --- 2. Display the raw HTML in a textarea for exporting ---
					?>
					<hr style="margin: 2em 0;">
					<h2>Raw HTML for Newsletter</h2>
					<p>Copy the code below to use in your email client or service.</p>
					<div>
						<button type="button" class="button button-primary" onclick="hnsCopyHtml(this)">Copy HTML</button>
						<textarea readonly id="hns-html-export" style="width: 100%; height: 400px; margin-top: 1em; font-family: monospace; white-space: pre; overflow-wrap: normal; overflow-x: scroll;"><?php echo esc_textarea( $html_for_export ); ?></textarea>
					</div>
					<script>
						function hnsCopyHtml(button) {
							const textarea = document.getElementById('hns-html-export');
							const originalText = button.textContent;

							// --- START: Improved Copy Logic ---
							// Modern browsers on secure sites (HTTPS)
							if (navigator.clipboard && window.isSecureContext) {
								navigator.clipboard.writeText(textarea.value).then(() => {
									// Success feedback
									button.textContent = 'Copied!';
									setTimeout(() => { button.textContent = originalText; }, 2000);
								}).catch(err => {
									console.error('Async: Could not copy text: ', err);
									alert('Failed to copy. Please use Ctrl+C.');
								});
							} else {
								// Fallback for older browsers or non-secure sites (HTTP)
								try {
									textarea.select();
									document.execCommand('copy');
									// Success feedback
									button.textContent = 'Copied!';
									setTimeout(() => { button.textContent = originalText; }, 2000);
								} catch (err) {
									console.error('Fallback: Oops, unable to copy', err);
									alert('Failed to copy. Please use Ctrl+C.');
								}
							}
							// --- END: Improved Copy Logic ---
						}
					</script>
					<?php

				} else {
					echo '<p>No articles found with the tag "' . esc_html( $tag_name ) . '".</p>';
				}
			} else {
				echo '<p>Please enter a tag name.</p>';
			}
		}
		?>
	</div>
	<?php
}


// The closing PHP tag is optional at the end of a file that is pure PHP.
// It's often recommended to omit it to prevent accidental whitespace output.
